SET QUOTED_IDENTIFIER OFF
DECLARE @SQL NVARCHAR(MAX), @FACILITY_CODE NVARCHAR(10), @CD_CODE NVARCHAR(20), @VISTA_CODE NVARCHAR(20), @FACILITY_UID UNIQUEIDENTIFIER, @FACILITY_ID INT
BEGIN TRY
	BEGIN TRANSACTION;
		SET @FACILITY_CODE = '$(varFacilityCode)'
		SELECT @VISTA_CODE = V.IDENTIFIER_EXTENSION, @FACILITY_UID = E.IDENTIFIER, @FACILITY_ID = E.PK_ENTITY
		FROM BMS_EIS.dbo.ENTITY AS E 
			INNER JOIN BMS_EIS.dbo.EHL7_ORGANIZATION AS O ON O.PFK_ORGANIZATION = E.PK_ENTITY
			INNER JOIN BMS_EIS.dbo.EHL7_UID AS F ON  E.PK_ENTITY = F.FK_ENTITY AND F.IDENTIFIER_ROOT = 'CODE'
			INNER JOIN BMS_EIS.dbo.EHL7_ROLE AS R ON R.FK_PLAYER_ENTITY =  E.PK_ENTITY AND R.CLASS_CODE = 'MBR'
			INNER JOIN BMS_EIS.dbo.EHL7_UID AS V ON R.FK_SCOPER_ENTITY = V.FK_ENTITY AND V.IDENTIFIER_ROOT = 'CODE'
		WHERE F.IDENTIFIER_EXTENSION = @FACILITY_CODE AND O.CODE_CODE = 'FAC'
		SET @CD_CODE = @VISTA_CODE + '_' + @FACILITY_CODE + '_'

		--DELETE UNAVAILABLE REASON, WAITING AREA, ADT ORDERABLE ITEMS
		DELETE FROM BMS_EVS.dbo.conceptproperty WHERE CONCEPTCODE LIKE '' + @CD_CODE + '' + '%'
		AND codingSchemeName IN ('WaitingArea', 'ADTOrderableItem', 'UnavailableReason')
		DELETE FROM BMS_EVS.dbo.voc_nested_value_set WHERE CONCEPTCODE LIKE '' + @CD_CODE + '' + '%'
		AND codingSchemeName IN ('WaitingArea', 'ADTOrderableItem', 'UnavailableReason')
		DELETE FROM BMS_EVS.dbo.concept WHERE CONCEPTCODE LIKE '' + @CD_CODE + '' + '%'
		AND codingSchemeName IN ('WaitingArea', 'ADTOrderableItem', 'UnavailableReason')
		
		CREATE TABLE #CONCEPT(ID INT)
		INSERT INTO #CONCEPT(ID)
		SELECT ID FROM BMS.dbo.concept WHERE CODE LIKE '' + @CD_CODE + '' + '%'
		AND CODE_SYSTEM_NAME IN ('WaitingArea', 'ADTOrderableItem', 'UnavailableReason') 

		DELETE C FROM BMS.dbo.CONCEPT AS C
		INNER JOIN #CONCEPT AS DEL ON DEL.ID = C.ID

		DELETE C FROM BMS_HISTORY.dbo.CONCEPT_H AS C
		INNER JOIN #CONCEPT AS DEL ON DEL.ID = C.ID

		DROP TABLE #CONCEPT

		--DELETE CONFIG BED BOARD AND EMS NOTIFICATION
		CREATE TABLE #CONFIG(ID INT)
		INSERT INTO #CONFIG(ID)
		SELECT ID FROM BMS.dbo.CONFIG
		WHERE SECTION LIKE '' + 'BedBoardModule ' + '' + CAST(@FACILITY_UID AS NVARCHAR(50)) + '' + '%'
			  OR SECTION LIKE '' + 'EMSNotification ' + '' + CAST(@FACILITY_UID AS NVARCHAR(50)) + '' + '%'

		DELETE CONFIG_EVS FROM BMS.dbo.CONFIG_EVS AS CONFIG_EVS
		INNER JOIN #CONFIG AS DEL ON DEL.ID = CONFIG_EVS.CONFIG_ID

		DELETE CONFIG_EVS FROM BMS_HISTORY.dbo.CONFIG_EVS_H AS CONFIG_EVS
		INNER JOIN #CONFIG AS DEL ON DEL.ID = CONFIG_EVS.CONFIG_ID

		DELETE C FROM BMS.dbo.CONFIG AS C
		INNER JOIN #CONFIG AS DEL ON DEL.ID = C.ID

		DELETE C FROM BMS_HISTORY.dbo.CONFIG_H AS C
		INNER JOIN #CONFIG AS DEL ON DEL.ID = C.ID

		DROP TABLE #CONFIG

		-- GET WARDGROUP
		CREATE TABLE #WARDGROUP(WARDGROUP_ID INT)
		INSERT INTO #WARDGROUP(WARDGROUP_ID)
		SELECT DISTINCT O.PFK_ORGANIZATION
		FROM BMS_EIS.[dbo].[EHL7_ORGANIZATION] AS O
		INNER JOIN BMS_EIS.[dbo].[EHL7_ROLE] AS R ON O.PFK_ORGANIZATION = R.FK_PLAYER_ENTITY AND R.[CLASS_CODE] = 'MBR'
		WHERE O.CODE_DISPLAY_NAME ='WARD GROUP' AND R.FK_SCOPER_ENTITY = @FACILITY_ID

		--GET WARD
		CREATE TABLE #WARDS(WARD_ID INT, WARD_UID UNIQUEIDENTIFIER)
		INSERT INTO #WARDS (WARD_ID, WARD_UID)
		SELECT P.PFK_PLACE, E.IDENTIFIER
		FROM BMS_EIS.dbo.EHL7_PLACE AS P
			INNER JOIN BMS_EIS.dbo.ENTITY AS E ON P.PFK_PLACE = E.PK_ENTITY
			INNER JOIN BMS_EIS.dbo.EHL7_ROLE AS R ON R.FK_PLAYER_ENTITY = P.PFK_PLACE AND R.CLASS_CODE = 'SDLOC'
			INNER JOIN #WARDGROUP AS WARDGROUP ON WARDGROUP.WARDGROUP_ID = R.FK_SCOPER_ENTITY
		WHERE P.CODE_CODE = 'WRD' 

		--DELETE ALL ROLES (WARDGROUP)
		DELETE SCOPER_ROLE FROM BMS_EIS.dbo.EHL7_ROLE AS SCOPER_ROLE
		INNER JOIN #WARDGROUP AS WARDGROUP ON WARDGROUP.WARDGROUP_ID = SCOPER_ROLE.FK_SCOPER_ENTITY

		DELETE PLAYER_ROLE FROM BMS_EIS.dbo.EHL7_ROLE AS PLAYER_ROLE
		INNER JOIN #WARDGROUP AS WARDGROUP ON WARDGROUP.WARDGROUP_ID = PLAYER_ROLE.FK_PLAYER_ENTITY


		--UPDATE TRAIT WARD (TYPE_GROUP AND IS_ACTIVE)
		SET @SQL = NULL
		SELECT @SQL = COALESCE(@SQL, ' ') + '
				EXEC BMS_EIS.dbo.DEL_TRAIT_VALUE @ENTITY_IDENTIFIER=N''' + CAST(W.WARD_UID AS NVARCHAR(50)) + ''',@DOMAIN_IDENTIFIER=N''InfoWorld'',@ENTITY_TYPE_IDENTIFIER=N''HL7-RIM-V3-Place'',@TRAIT_IDENTIFIER=N''TYPE_GROUP''
				EXEC BMS_EIS.dbo.DEL_TRAIT_VALUE @ENTITY_IDENTIFIER=N''' + CAST(W.WARD_UID AS NVARCHAR(50)) + ''',@DOMAIN_IDENTIFIER=N''InfoWorld'',@ENTITY_TYPE_IDENTIFIER=N''HL7-RIM-V3-Place'',@TRAIT_IDENTIFIER=N''IS_ACTIVE'''
		FROM #WARDS AS W
		EXEC sp_executesql @SQL

		--DELETE WARDFROUP
		DELETE TV FROM BMS_EIS.dbo.TRAIT_VALUE AS TV
		INNER JOIN #WARDGROUP AS WARDGROUP ON WARDGROUP.WARDGROUP_ID = TV.FK_ENTITY

		DELETE WARDGROUP_UID FROM BMS_EIS.dbo.EHL7_UID AS WARDGROUP_UID
		INNER JOIN #WARDGROUP AS WARDGROUP ON WARDGROUP.WARDGROUP_ID = WARDGROUP_UID.FK_ENTITY

		DELETE O FROM BMS_EIS.dbo.EHL7_ORGANIZATION AS O
		INNER JOIN #WARDGROUP AS WARDGROUP ON WARDGROUP.WARDGROUP_ID = O.PFK_ORGANIZATION

		DELETE E FROM BMS_EIS.dbo.ENTITY AS E
		INNER JOIN #WARDGROUP AS WARDGROUP ON WARDGROUP.WARDGROUP_ID = E.PK_ENTITY

		DROP TABLE #WARDGROUP
		DROP TABLE #WARDS

		--DISCHARGE APPOINTMENT CLINICS
		CREATE TABLE #HLA(ID INT)
		INSERT INTO #HLA(ID)
		SELECT ID FROM BMS.dbo.HOSPITAL_LOCATION_APPOINTMENT WHERE FACILITY_UID = @FACILITY_UID

		DELETE HLA FROM BMS.dbo.HOSPITAL_LOCATION_APPOINTMENT AS HLA
		INNER JOIN #HLA AS DEL ON DEL.ID = HLA.ID

		DELETE HLA FROM BMS_HISTORY.dbo.HOSPITAL_LOCATION_APPOINTMENT_H AS HLA
		INNER JOIN #HLA AS DEL ON DEL.ID = HLA.ID

		DROP TABLE #HLA
		SELECT 'Site Options - successfully deleted'
	COMMIT TRANSACTION;
END TRY
BEGIN CATCH
	 SELECT  ERROR_LINE() AS ErrorLine,
			 ERROR_MESSAGE() AS ErrorMessage
	ROLLBACK TRANSACTION;
END CATCH;
SET QUOTED_IDENTIFIER ON




   